/'
	---------------------------------------------------------------------
	Copyright (C) 2017 Frank Hoogerbeets <contact@basicstudio.org>
	---------------------------------------------------------------------
	This library is free software; you can redistribute it and/or modify
	it under the terms of the Modified GNU Library General Public
	License either version 2.0 of the License, or (at your option) any
	later version.

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
	
	See the Modified GNU Library General Public License for more details:
	http://www.basicstudio.org/mlgpl.html
	http://www.basicstudio.org/mlgpl.txt
	---------------------------------------------------------------------
'/
#include once "crt/string.bi"

' pointer nil indicator for easy reading
#define nil 0

' variable within range check macro
#define within_max_(x, y) iif(x > y, x, y)
#define within_min_(x, y) iif(x < y, x, y)
#define Within(x, y, v) iif((v) >= within_min_((x), (y)) _
	andalso (v) <= within_max_((x), (y)), true, false)

type PChar as zstring ptr
type PCChar as const zstring ptr

' for easy reading and possible future adjustment
type UString as string

' general procedures
declare function ByteIndex(b as any ptr, byval size as uinteger, _
	byval chval as ubyte) as integer
declare sub ResizeStr(byref s as string, byval size as uinteger)

' string routines supporting UTF-8
declare function UAsc(byref value as const ustring) as uinteger
declare function UChr(byval value as uinteger) as ustring
declare function UInsert overload (byref s1 as const ustring, _
	byref s2 as const ustring, byval start as uinteger) as const ustring
declare function UInsert overload (byref s1 as const ustring, _
	byref s2 as const ustring, byval start as uinteger, _
	byval count as uinteger) as const ustring
declare function UInstr overload (byref sp as const ustring, _
	byref sb as const ustring) as integer
declare function UInstr overload (byval spos as uinteger, _
	byref sp as const ustring, byref sb as const ustring) as integer
declare function UIsAscii(byref s as const ustring) as boolean
declare function UIvstr(byref s as const string) as boolean
declare function ULCase(byref s as const ustring, _
	byref lang as const string = "") as const ustring
declare function ULeft(byref s as const ustring, _
	byval count as uinteger) as const ustring
declare function ULen(byref s as const ustring) as uinteger
declare function UMid overload (byref s as const ustring, _
	byval start as uinteger, byval count as uinteger) as const ustring
declare function UMid overload (byref s as const ustring, _
	byval start as uinteger) as const ustring
declare function URemove(byref s as ustring, byval start as uinteger, _
	byval count as uinteger) as const ustring
declare sub URepair(byref s as string)
declare sub UReplace(byref t as string, byref i as const string, _
byref s as const string, byval a as integer = 1)
declare sub UReplaceAll(byref t as ustring, byref i as const ustring, _
	byref s as const ustring, byval a as integer = 1)
declare function UReverse(byref s as const ustring) as ustring
declare function URight(byref s as const ustring, _
	byval count as uinteger) as const ustring
declare function UUCase(byref s as const ustring, _
	byref lang as const string = "") as const ustring
