' -------------------------------------------------------------
' Affichage des caracteres Emoji
' Source : unicode.org/emoji/charts/full_emoji_list.html
' -------------------------------------------------------------
' Ce programme est en FreeBASIC
' Compiler par : \FBPano\fb\fbc.exe emoji.bas
' -------------------------------------------------------------

#include "fltk-main.bi"
#include "utf8.bi"

dim shared as Fl_Window  ptr form
dim shared as Fl_Tree    ptr tv
dim shared as Fl_Button  ptr btCopy

function tree_item_read (tv as Fl_Widget ptr) as string
' Lecture de l'element selectionne dans le Treeview

  dim as Fl_Tree ptr tr = cptr(Fl_Tree ptr, tv)
  dim as Fl_Tree_Item ptr item = Fl_TreeGetCallbackItem(tr)
  if item = 0 then return ""
  
  if Fl_TreeGetCallbackReason(tr) = FL_TREE_REASON_SELECTED then
    return *Fl_Tree_ItemGetLabel(item) 
  end if  
end function

sub Click_btCopy cdecl (byval self as Fl_Widget ptr)
' Copie le code du caractere dans le presse-papier 

  var s = tree_item_read(tv)
  s = "&h" + rtrim(umid(s, 3, 5))
  Fl_Copy(s, len(s), 1)
end sub

dim as long i, n
dim as string a, cat, code, txt

form = Fl_Double_WindowNew2(50, 50, 400, 570, "Caractres Emoji")

tv = Fl_TreeNew(10, 10, 380, 500)

Fl_TreeSetShowRoot tv, 0
Fl_TreeSetItemLabelFont tv, FL_HELVETICA
Fl_TreeSetItemLabelSize tv, 30

btCopy = Fl_ButtonNew(10, 520, 380, 35, "Copier le code du caractre dans le presse-papier")
Fl_WidgetSetCallback0 btCopy, @Click_btCopy

open "emoji.bi" for input as #1

input #1, a
input #1, a

while not eof(1)
  input #1, a
  a = rtrim(a)
  if a <> "" then
    if right(a, 1) = ":" then 
      cat = rtrim(a, ":")
    else
      code = mid(a, 8, 5)
      txt = cat + "/" + uchr(val("&h" + code)) + " " + code 
      var item = Fl_TreeAdd(tv, txt)
      if n = 0 then Fl_TreeSelectItem tv, item
      n += 1
    end if  
  end if  
wend

Fl_WindowShow form
Fl_Run