#INCLUDE "dislin_d.bi"

DIM n% = 50
DIM zmat(n,n), xray(n), yray(n)
DIM x, y, stp, fpi, i%, j%

fpi = pi / 180
stp = 360.0 / n

FOR i = 0 TO n
  x = i * stp
  xray(i) = x
  FOR j = 0 TO n
    y = j * stp
    yray(j) = y
    zmat (i,j) = 2 * sin (x * fpi) * sin (y * fpi)
  NEXT j
NEXT i

Dislin.metafl ("cons")
Dislin.setpag ("da4p")
Dislin.scrmod ("revers")
Dislin.disini ()
Dislin.pagera ()
Dislin.hwfont ()

Dislin.titlin ("Shaded Surface Plot", 2)
Dislin.titlin ("F(X,Y) = 2 * SIN(X) * SIN(Y)", 4)

Dislin.axspos (200, 2600)
Dislin.axslen (1800, 1800)

Dislin.name   ("X-axis", "X")
Dislin.name   ("Y-axis", "Y")
Dislin.name   ("Z-axis", "Z")

Dislin.view3d (-5.0, -5.0, 4.0, "ABS")
Dislin.graf3d (0.0, 360.0, 0.0, 90.0, 0.0, 360.0, 0.0, 90.0, -3.0, 3.0, -3.0, 1.0)
Dislin.height (50)
Dislin.title  ()

Dislin.shdmod ("smooth", "surface")
Dislin.surshd (t1adr(xray), n + 1, t1adr(yray), n + 1, t2adr(zmat))
Dislin.disfin ()
END
