#INCLUDE "dislin_d.bi"
#INCLUDE "surfcp_func.inc"

DIM stp, pi2

Dislin.scrmod ("revers")
Dislin.metafl ("xwin")
Dislin.setpag ("da4p")
Dislin.disini ()
Dislin.pagera ()
Dislin.complx ()

Dislin.titlin ("Surface Plot of the Parametric Function", 2)
Dislin.titlin ("[COS(t)*(3+COS(u)), SIN(t)*(3+COS(u)), SIN(u)]", 4)

Dislin.axspos (200, 2400)
Dislin.axslen (1800, 1800)

Dislin.name   ("X-axis", "X")
Dislin.name   ("Y-axis", "Y")
Dislin.name   ("Z-axis", "Z")
Dislin.intax  ()

Dislin.vkytit (-300)
Dislin.zscale (-1.0, 1.0)
Dislin.surmsh ("on")

Dislin.graf3d (-4.0 ,4.0, -4.0, 1.0, -4.0, 4.0, -4.0, 1.0, -3.0, 3.0, -3.0, 1.0)
Dislin.height (40)
Dislin.title  ()

pi2 = 2 * pi
stp = pi2 / 30.0

Dislin.surfcp (fadr(myfunc), 0.0, pi2, stp, 0.0, pi2, stp)
Dislin.disfin ()
END



