#INCLUDE "dislin_d.bi"

DIM n% = 300
DIM xray(n), y1ray(n), y2ray(n)
DIM x, stp, fpi, i%, nx%, ny%
DIM cbuf$

cbuf = space$(80)

fpi = pi / 180
stp = 360.0 / n

FOR i = 0 TO n
  xray(i) = i * stp
  x = xray(i) * fpi
  y1ray(i) = sin (x)
  y2ray(i) = cos (x)
NEXT i

Dislin.metafl ("xwin")
Dislin.disini ()
Dislin.pagera ()
Dislin.complx ()

Dislin.axspos (450, 1800)
Dislin.axslen (2200, 1200)

Dislin.name ("X-axis", "X")
Dislin.name ("Y-axis", "Y")

Dislin.labdig (-1, "X")
Dislin.ticks (10, "XY")

Dislin.titlin ("Demonstration of CURVE", 1)
Dislin.titlin ("SIN(X), COS(X)", 3)

Dislin.graf (0.0, 360.0, 0.0, 90.0, -1.0, 1.0, -1.0, 0.5)
Dislin.xaxgit ()
Dislin.title ()

Dislin.chncrv ("Both")
Dislin.curve (t1adr(xray), t1adr(y1ray), n + 1)
Dislin.curve (t1adr(xray), t1adr(y2ray), n + 1)

Dislin.legini (cbuf, 2, 7)
nx = Dislin.nxposn (190.0)
ny = Dislin.nyposn (0.75)
Dislin.legpos (nx, ny)
Dislin.leglin (cbuf, "sin (x)", 1)
Dislin.leglin (cbuf, "cos (x)", 2)
Dislin.legtit ("Legend")
Dislin.legend (cbuf, 3)

Dislin.disfin ()
END
