#INCLUDE "dislin_d.bi"

DIM n% = 60, m% = 50
DIM xray(n), yray(m),zmat(n,m)
DIM fpi, stpx, stpy, zlev, i%, j%
DIM ctit1$, ctit2$

ctit1 = "Contour Plot"
ctit2 = "F(X,Y) = 2 * SIN(X) * SIN (Y)"

fpi  = pi / 180.0
stpx = 360.0 / n
stpy = 360.0 / m

FOR i = 0 TO n
  xray(i) = i * stpx
  FOR j = 0 TO m
    yray(j) = j * stpy
    zmat(i,j) = 2 * sin(xray(i) * fpi) * sin(yray(j) * fpi)
  NEXT j
NEXT i

Dislin.scrmod ("revers")
Dislin.metafl ("cons")
Dislin.setpag ("da4p")
Dislin.disini ()
Dislin.pagera ()
Dislin.complx ()

Dislin.titlin (ctit1, 2)
Dislin.titlin (ctit2, 4)

Dislin.axspos (450, 2670)

Dislin.intax  ()
Dislin.name   ("X-axis", "X")
Dislin.name   ("Y-axis", "Y")
Dislin.graf   (0., 360., 0., 90., 0., 360., 0., 90.)

Dislin.height (30)
FOR i = 0 TO 8
  zlev = -2. + i * 0.5
  IF i = 4 THEN
    Dislin.labels ("NONE", "CONTUR")
  ELSE
    Dislin.labels ("FLOAT", "CONTUR")
  END IF
  Dislin.setclr ((i+1) * 28)
  Dislin.contur (t1adr(xray), n + 1, t1adr(yray), m + 1, t2adr(zmat), zlev)
NEXT i

Dislin.color  ("FORE")
Dislin.height (50)
Dislin.title  ()
Dislin.disfin ()
END
