#INCLUDE "dislin_d.bi"

DIM n% = 50, m% = 80
DIM xray(n), yray(m), zmat(n,m), zlev(11)
DIM stpx, stpy, x, x2, y, y2, i%, j%
DIM ctit1$, ctit2$

ctit1 = "Shaded Contour Plot"
ctit2 = "F(X,Y) = (X[2$ - 1)[2$ + (Y[2$ - 1)[2$"

stpx = 1.6 / n
stpy = 1.6 / n

FOR i = 0 TO n
  xray(i) = i * stpx
  x = xray(i) * xray(i) - 1.0
  x2 = x * x
  FOR j = 0 TO m
    yray(j) = j * stpy
    y = yray(j) * yray(j) - 1.0
    y2 = y * y
    zmat(i,j) = x2 + y2
  NEXT j
NEXT i

Dislin.scrmod ("revers")
Dislin.metafl ("cons")
Dislin.setpag ("da4p")

Dislin.disini ()
Dislin.pagera ()
Dislin.complx ()
Dislin.mixalf ()

Dislin.titlin (ctit1, 1)
Dislin.titlin (ctit2, 3)

Dislin.name   ("X-axis", "X")
Dislin.name   ("Y-axis", "Y")

Dislin.axspos (450, 2670)
Dislin.shdmod ("poly", "contur")
Dislin.graf   (0., 1.6, 0., 0.2, 0., 1.6, 0., 0.2)

FOR i = 0 TO 11
  zlev(11-i) = 0.1 + i * 0.1
NEXT i

Dislin.conshd (t1adr(xray), n + 1, t1adr(yray), m + 1, t2adr(zmat), t1adr(zlev), 12)

Dislin.height (50)
Dislin.title  ()
Dislin.disfin ()
END

