' **********************************************************************
' Nombres de Mersenne - Decomposition en facteurs premiers
' **********************************************************************

#include "bigint.bi"

' ----------------------------------------------------------------------
' Initialisation de la bibliotheque
' ----------------------------------------------------------------------

enum
  N4 = 4, N5      ' Indices des nombres
end enum

dim nDigits%      ' Nombre de chiffres max.

nDigits = BigInit(N5 + 1)

' ----------------------------------------------------------------------
' Programme principal
' ----------------------------------------------------------------------

dim n%

SetNum N4, 2         ' (N4) = 2

for n = 60 to 70
  BigPow N4, n, N5   ' (N5) = 2^n
  BigInc N5, -1      ' (N5) = 2^n - 1

  print using "2^## - 1 = "; n; 
  print using "\                      \ = "; GetStr(N5);
  print BigPrimDec(N5)
next n


