' **********************************************************************
' Comparaison, echange, incrementation
' **********************************************************************

#include "bigint.bi"

' ----------------------------------------------------------------------
' Initialisation de la bibliotheque
' ----------------------------------------------------------------------

enum
  a, b        ' Indices des nombres : a = 0 etc.
end enum
  
BigInit b + 1

' ----------------------------------------------------------------------
' Programme principal
' ----------------------------------------------------------------------

SetNum a, 12345   ' (a) = 12345
SetNum b, 67890   ' (b) = 67890

print_a_b

select BigCmp(a, b)
  case -1 : print "(a) < (b)"
  case  0 : print "(a) = (b)"
  case  1 : print "(a) > (b)"
end_select
print

BigSwap a, b   ' (a) = 67890, (b) = 12345

print_a_b

select BigIsf(b, 12345)
  case -1 : print "(b) = 12345"
  case  0 : print "(b) <> 12345"
end_select
print

BigInc b, 5   ' (b) = 12350

print_a_b

select BigIsf(b, 12350)
  case -1 : print "(b) = 12350"
  case  0 : print "(b) <> 12350"
end_select

print

' ----------------------------------------------------------------------
' Sous-programme
' ----------------------------------------------------------------------

sub print_a_b ()
  print
  print "(a) ="; GetStr(a)
  print "(b) ="; GetStr(b)
end_sub
