' **********************************************************************
' Demonstration de la bibliotheque BIGINT
' **********************************************************************

#include "bigint.bi"

' ----------------------------------------------------------------------
' Initialisation de la bibliotheque
' ----------------------------------------------------------------------

enum
  a, b, c, p, q, r, s, z  ' Indices des nombres : a = 0 etc.
end enum
  
dim nDigits%              ' Nombre de chiffres max.

nDigits = BigInit(z + 1)

print "Nous avons reserve"; z + 1; " nombres pouvant avoir jusqu'a"; 
print nDigits; " chiffres chacun"

' ----------------------------------------------------------------------
' Affectation de valeurs
' ----------------------------------------------------------------------

' Affectation par un nombre entier (32 bits)
SetNum a, 123456789

' Affectation par une chaine de caracteres
SetStr b, "1267650600228229401496703205376"  : ' 2^100

' Affectation par un entier aleatoire de n bits
' Intervalle [2^(n - 1) .. 2^n - 1]
SetRnd c, 128                                : ' 128 bits

' ----------------------------------------------------------------------
' Lecture de la valeur d'un nombre dans une chaine de caracteres
' ----------------------------------------------------------------------

print
print "(a) = "; GetStr(a)
print "(b) = "; GetStr(b)
print "(c) = "; GetStr(c)

' ----------------------------------------------------------------------
' Operations arithmetiques
' ----------------------------------------------------------------------

BigDiv c, b, q, r  ' (q) = (c) \ (b), (r) = (c) mod (b)

print
print "Division entiere : (q) = (c) \ (b)   = "; GetStr(q)
print "                   (r) = (c) mod (b) = "; GetStr(r)

BigMul b, q, p  ' (p) = (b) * (q)
BigAdd p, r, s  ' (s) = (p) + (r)
BigSub s, c, z  ' (z) = (s) - (c)

print
print "Verification : (b) * (q) + (r) - (c) = "; GetStr(z)

print
print "Approximation rationnelle : (c) / (b) ~ "; BigRat(c, b, 30)
print

