' *******************************************************************
' Amstrad CPC graphic functions
' *******************************************************************

#inclib "amsgraph"

' -------------------------------------------------------------------
' Amstrad color palette
' -------------------------------------------------------------------

#define CL_BLACK          &hFF000000
#define CL_BLUE           &hFF000080
#define CL_BRIGHT_BLUE    &hFF0000FF
#define CL_RED            &hFF800000
#define CL_MAGENTA        &hFF800080
#define CL_MAUVE          &hFF8000FF
#define CL_BRIGHT_RED     &hFFFF0000
#define CL_PURPLE         &hFFFF0080
#define CL_BRIGHT_MAGENTA &hFFFF00FF
#define CL_GREEN          &hFF008000
#define CL_CYAN           &hFF008080
#define CL_SKY_BLUE       &hFF0080FF
#define CL_YELLOW         &hFF808000
#define CL_WHITE          &hFF808080
#define CL_PASTEL_BLUE    &hFF8080FF
#define CL_ORANGE         &hFFFF8000
#define CL_PINK           &hFFFF8080
#define CL_PASTEL_MAGENTA &hFFFF80FF
#define CL_BRIGHT_GREEN   &hFF00FF00
#define CL_SEA_GREEN      &hFF00FF80
#define CL_BRIGHT_CYAN    &hFF00FFFF
#define CL_LIME           &hFF80FF00
#define CL_PASTEL_GREEN   &hFF80FF80
#define CL_PASTEL_CYAN    &hFF80FFFF
#define CL_BRIGHT_YELLOW  &hFFFFFF00
#define CL_PASTEL_YELLOW  &hFFFFFF80
#define CL_BRIGHT_WHITE   &hFFFFFFFF

' -------------------------------------------------------------------
' Mouse buttons
' -------------------------------------------------------------------

#define BUTTON_LEFT	  1
#define BUTTON_RIGHT  2
#define BUTTON_MIDDLE 4

' -------------------------------------------------------------------
' Graphics functions
' -------------------------------------------------------------------

declare sub      mode           (m as long, title as string = "", w as long = 640, h as long = 400, w1 as long = 2, h1 as long = 2)

declare sub      origin         (x as long = 0, y as long = 0, lft as long = 0, rgt as long = 0, top as long = 0, bottom as long = 0, fill_color as ulongint = &h100000000, border_color as ulongint = &h100000000) 

declare sub      move           (x as long, y as long) 

declare function test           (x as long, y as long) as ulong

declare sub      plot           (x as long, y as long, col as ulongint = &h100000000) 

declare sub      ldraw          (x as long, y as long, col as ulongint = &h100000000) 

declare sub      mover          (x as long, y as long)

declare function testr          (x as long, y as long) as ulong

declare sub      plotr          (x as long, y as long, col as ulongint = &h100000000) 

declare sub      ldrawr         (x as long, y as long, col as ulongint = &h100000000) 

declare sub      gcls           () 

declare sub      crlocate       (x as long, y as long)
    
declare sub      aprint         (txt as string, x as ulongint = &h100000000, y as ulongint = &h100000000)

declare sub      fbprint        (txt as string, x as ulongint, y as ulongint)

declare sub      symbol         (code as long, n0 as long, n1 as long, n2 as long, n3 as long, n4 as long, n5 as long, n6 as long, n7 as long)

declare sub      symbcol        (code as long, s as string)

declare sub      PICtoCHAR      (filename as string, code as long)
 
declare sub      paper          (col as ulong)

declare sub      pen            (col as ulong)

declare sub      ink            (i as ubyte, col as ulong)

declare function get_ink        (i as ubyte) as ulong

declare sub      rectangle      (x as long, y as long, w as long, h as long)

declare sub      rectangle_fill (x as long, y as long, w as long, h as long)

declare sub      arc            (ctrx as long, ctry as long, rx as long, ry as long = 0, angle1 as long = 0, angle2 as long = 360)

declare sub      pie            (ctrx as long, ctry as long, rx as long, ry as long = 0)

declare sub      fill           (paint_col as ulongint, border_col as ulongint = &h100000000)

declare sub      fill_pattern   (numchar as long, border_col as ulongint = &h100000000)

declare sub      get_mouse      (byref x as long, byref y as long, byref btn as long = 0, byref wheel as long = 0)

declare sub      img_save       (filename as string, transp as long = FALSE)

declare sub      img_load       (filename as string)

declare sub      img_load_trans (filename as string)

declare sub      RGBtoHSV       (R as long, G as long, B as long, byref H as double, byref S as double, byref V as double)

declare sub      HSVtoRGB       (H as double, S as double, V as double, byref R as long, byref G as long, byref B as long)

declare function ainkey         () as string

 


