' Function plotter

#include "amsgraph.bi"

' For the FORMAT function
#include "string.bi"  

' Define here the function to be plotted
#define func(x)  ( sin(exp((x))) )

declare sub Plot_Ox_Axis ()
declare sub Plot_Oy_Axis ()
declare sub Plot_Func ()

' ------------------------------------------------
' Program data - Modifiy as necessary
' ------------------------------------------------

data 75, 567   ' Ox scale (pixels)
data 40, 380   ' Oy scale (pixels)

data -3.0, 3.0 ' Ox scale (user coordinates)
data -1.0, 1.0 ' Oy scale (user coordinates)

data 6, 1      ' Nb of divisions and decimals on Ox
data 4, 1      ' Nb of divisions and decimals on Oy

data 500       ' Nb of points to plot the curve

data &h000000  ' Background color
data &h00FFFF  ' Foreground color
data &h00FF00  ' Curve color

data "f(x) = sin(exp(x))"  ' Function name

' ------------------------------------------------
' Global variables - Initialization
' ------------------------------------------------

dim shared as long xminpixel, xmaxpixel, yminpixel, ymaxpixel
dim shared as double xmin, xmax, ymin, ymax
dim shared as long ndivx, ndecx, ndivy, ndecy
dim shared as long np
dim shared as long bg_color, axis_color, plot_color
dim shared as string funcname

read xminpixel, xmaxpixel, yminpixel, ymaxpixel
read xmin, xmax, ymin, ymax
read ndivx, ndecx, ndivy, ndecy
read np
read bg_color, axis_color, plot_color
read funcname

dim shared as double xfact, yfact, x, y, dx, dy
dim shared as long xp, yp, dxp, dyp, xs, ys, i
dim shared as string lbl

xfact = (xmaxpixel - xminpixel) / (xmax - xmin) 
yfact = (ymaxpixel - yminpixel) / (ymax - ymin)

' ------------------------------------------------
' Conversion functions 
' User coord. --> screen coord.
' ------------------------------------------------

#define xpixel(x)  ( (xfact) * ((x) - (xmin)) )

#define ypixel(y)  ( (yfact) * ((y) - (ymin)) )

' ------------------------------------------------
' Formatting function 
' ------------------------------------------------

#define float2str(x, ndec)  ( format((x), "###0." + string((ndec), "0")) )

' ------------------------------------------------
' Main program
' ------------------------------------------------

mode 2, funcname

pen axis_color : Plot_Ox_Axis() : Plot_Oy_Axis()

origin xminpixel, yminpixel, xminpixel, xmaxpixel, ymaxpixel, yminpixel, bg_color, axis_color 

pen plot_color : Plot_Func()

while ainkey() = "" : wend

' ------------------------------------------------
' Subprograms
' ------------------------------------------------

sub Plot_Ox_Axis ()

  x = xmin
  xp = xminpixel

  dx = (xmax - xmin) / ndivx
  dxp = (xmaxpixel - xminpixel) \ ndivx

  move xminpixel, yminpixel
  ldraw xmaxpixel, yminpixel

  for i = 0 to ndivx
    move xp, yminpixel
    ldraw xp, yminpixel - 6    ' Tick mark

    lbl = float2str(x, ndecx)  ' Label
    xs = xp - 4 * len(lbl)     ' Label position
    ys = yminpixel - 14
    aprint lbl, xs, ys         ' Write label

    x = x + dx
    xp = xp + dxp
  next i
end sub


sub Plot_Oy_Axis ()

  y = ymin
  yp = yminpixel

  dy = (ymax - ymin) / ndivy
  dyp = (ymaxpixel - yminpixel) \ ndivy

  move xminpixel, yminpixel
  ldraw xminpixel, ymaxpixel

  for i = 0 to ndivy
    move xminpixel, yp
    ldraw xminpixel - 6, yp                  ' Tick mark

    lbl = float2str(y, ndecy)                ' Label
    xs = xminpixel - (len(lbl) + 1) * 8 - 4  ' Label position
    ys = yp + 8
    aprint lbl, xs, ys                       ' Write label

    y = y + dy
    yp = yp + dyp
  next i
end sub


sub Plot_Func ()

  x = xmin
  dx = (xmax - xmin) / (np + 1)

  plot xpixel(x), ypixel(func(x))
  
  for i = 1 to np
    x = x + dx
    ldraw xpixel(x), ypixel(func(x))
  next i
end sub
