' PICtoCHAR Demo

#include "amsgraph.bi"

' -------------------------------------------------------------------
' Source of picture : https://opengameart.org/content/lpc-fruit-trees

' "[LPC] Fruit Trees" by bluecarrot16, Joshua Taylor, and cynicmusic. 
' Commissioned by castelonia.

' CC-BY-SA 3.0 / GPL 3.0

' ## BASED ON:

' Fruit and Veggie Inventory
' JT = Joshua Taylor
' CC-BY-SA 3.0 / GPL 3.0 
' https://opengameart.org/content/fruit-and-veggie-inventory

' Pixelsphere 32x32 Tileset + Grass + Trees
' cynicmusic
' CC0
' http://opengameart.org/content/pixelsphere-32x32-tileset-grass-trees
' --------------------------------------------------------------------

const W = 96, H = 120  ' Size of sprites

const DegToRad = 0.0174532925199433

dim as double a, ar, x, y
dim as long code

code = 128

mode 3, "PICtoCHAR Demo", 500, 550, W \ 8, H \ 8

pictochar "fruit-trees.png", code

origin 250, 275

paper CL_BLACK : gcls

for a = 0 to 324 step 36
  ' Angle in radians
  ar = a * DegToRad
  
  ' Sprite position (upper left corner)
  x = 200 * cos(ar) - W \ 2
  y = 200 * sin(ar) + H \ 2

  ' Display sprite
  aprint chr(code), x , y 
  
  code = code + 1
next a

while ainkey() = "" : wend