' Color Palette

#include "amsgraph.bi"

dim as string block, block2
dim as double gg, rr, bb, H, S, V
dim as long c, R, G, B, x, y

block = chr(143)
block2 = block + block

mode 1, "Color palette"

paper &h000033 : gcls

' Predefined Amstrad colors

pen CL_BRIGHT_WHITE : crlocate 2, 2 : aprint "Amstrad : "

x = 12 : y = 2

for gg = 0 to 1 step 0.5
  for rr = 0 to 1 step 0.5
    for bb = 0 to 1 step 0.5
      c = rgb(255 * rr, 255 * gg, 255 * bb)
      pen c : crlocate x, y : aprint block
      x = x + 1
    next bb
  next rr
next gg

' HSV colors

pen CL_BRIGHT_WHITE : crlocate 2, 5 : aprint "HSV Colors : H=0..345"

x = 15 : y = 7

for V = 100 to 52 step -24
  for S = 100 to 52 step -24
    pen CL_BRIGHT_WHITE  
    crlocate 2, y : aprint "S=" & S
    crlocate 8, y : aprint "V=" & V
    for H = 0 to 345 step 15
      HSVtoRGB H, S / 100, V / 100, R, G, B
      pen rgb(R, G, B) : crlocate x, y : aprint block
      x = x + 1
    next H
    x = 15 : y = y + 1
  next S
  y = y + 1
next V

' Grey scale

pen CL_BRIGHT_WHITE : crlocate 2, 20
aprint "Grey scale : H=0, S=0, V=8..92"

x = 2 : y = 22

for V = 8 to 92 step 7
  HSVtoRGB 0, 0, V / 100, R, G, B
  pen rgb(R, G, B) : crlocate x, y : aprint block2
  x = x + 3
next V

while ainkey() = "" : wend

