' Table of Amstrad colors

#include "amsgraph.bi"

dim as string col(26) => { _
  "CL_BLACK",          _
  "CL_BLUE",           _
  "CL_BRIGHT_BLUE",    _
  "CL_RED",            _
  "CL_MAGENTA",        _
  "CL_MAUVE",          _
  "CL_BRIGHT_RED",     _
  "CL_PURPLE",         _
  "CL_BRIGHT_MAGENTA", _
  "CL_GREEN",          _
  "CL_CYAN",           _
  "CL_SKY_BLUE",       _
  "CL_YELLOW",         _
  "CL_WHITE",          _
  "CL_PASTEL_BLUE",    _
  "CL_ORANGE",         _
  "CL_PINK",           _
  "CL_PASTEL_MAGENTA", _
  "CL_BRIGHT_GREEN",   _
  "CL_SEA_GREEN",      _
  "CL_BRIGHT_CYAN",    _
  "CL_LIME",           _
  "CL_PASTEL_GREEN",   _
  "CL_PASTEL_CYAN",    _
  "CL_BRIGHT_YELLOW",  _
  "CL_PASTEL_YELLOW",  _
  "CL_BRIGHT_WHITE"}

dim as long n, c, x, y
dim as string block

block = string(5, 143)

mode 3, "Amstrad colors", 680, 480

paper &h000050 : gcls

for n = 0 to 26
  c = get_ink(n)
  if n >= 10 then x = 2 else x = 3 
  y = n + 2 
  pen CL_BRIGHT_WHITE
  crlocate x, y : aprint n & "  " & col(n)
  crlocate 34, y : aprint hex(c)
  pen c
  crlocate 27, y : aprint block
next n

while ainkey() = "" : wend

