' *******************************************************
' Graphic character editor
' *******************************************************

#include "amsgraph.bi"

declare sub LoadPalette ()
declare sub PrintPalette ()
declare sub PrintLegend ()
declare sub PrintChar (nchar as long)
declare sub PrintStr (nchar as long)
declare function CursColor (c as string) as string
declare sub PrintGrid (sprite as string)

const CAREDIT_FILE = "caredit.dat"

' -------------------------------------------------------

const Code = "ROYGBLPNHIWAEQUF " 

dim as long nchar = 206
dim as string*64 sprite

open CAREDIT_FILE for random as #1 len=64
get #1, nchar - 127, sprite
symbcol nchar, sprite

dim shared as long x, y, x1, y1 
dim as string a

x = 2 : y = 10 : x1 = x : y1 = y

#define index(x, y)  ( 8 * ((y) - 10) + ((x) - 2) + 1 )

mode 3, "Graphic character editor", 800, 350

LoadPalette
PrintPalette
PrintLegend

aprint chr(1) ' For printing control characters

PrintChar nchar
PrintGrid sprite
PrintStr nchar

do  
  a = ainkey()
  
  select case a
    case "RIGHT" 
      if x < 9 then x1 = x + 1
    
    case "LEFT"
      if x > 2 then x1 = x - 1
    
    case "DOWN"
      if y < 17 then y1 = y + 1
    
    case "UP"
      if y > 10 then y1 = y - 1
    
    case "+", "-"
      if a = "+" then 
        if nchar < 255 then nchar = nchar + 1
      else
        if nchar > 128 then nchar = nchar - 1
      end if
      
      get #1, nchar - 127, sprite
      symbcol nchar, sprite
      
      PrintChar nchar
      PrintGrid sprite
      PrintStr nchar
      
      x = 2 : y = 10 : x1 = x : y1 = y
      crlocate 2, 21 : aprint space(45)
    
    case "!"
      put #1, nchar - 127, sprite
      crlocate 2, 21 : pen CL_BRIGHT_WHITE
      aprint "Character " & nchar & " saved in file caredit.dat"
    
    case else
      a = ucase(a)
      if instr(Code, a) > 0 then
        if x < 9 then 
          x1 = x + 1
        elseif y < 17 then 
          y1 = y + 1 
        end if
        mid(sprite, index(x, y)) = a
        symbcol nchar, sprite
      end if
  end select

  if x1 <> x or y1 <> y or (x = 9 and y = 17) then
    PrintGrid sprite
    PrintStr nchar
  end if
 
  x = x1 : y = y1
loop until a = "ESCAPE"

close #1

end

' *******************************************************

sub LoadPalette ()
' PICO-8 palette: https://pico-8.fandom.com/wiki/Palette

  ink asc("R"), &hFF004D  ' Red
  ink asc("O"), &hFFA300  ' Orange
  ink asc("Y"), &hFFEC27  ' Yellow
  ink asc("G"), &h00E436  ' Green
  ink asc("B"), &h29ADFF  ' Blue
  ink asc("L"), &h83769C  ' Lavender  
  ink asc("P"), &h7E2553  ' Dark Purple
  ink asc("N"), &hAB5236  ' Brown
  ink asc("H"), &hFFCCAA  ' Light Peach
  ink asc("I"), &hFF77A8  ' Pink
  ink asc("W"), &hFFF1E8  ' White
  ink asc("A"), &h000000  ' Black
  ink asc("E"), &hC2C3C7  ' Light Grey
  ink asc("Q"), &h5F574F  ' Dark Grey
  ink asc("U"), &h1D2B53  ' Dark Blue
  ink asc("F"), &h008751  ' Dark Green
  ink asc(" "), &h000080  ' Background color (transparency)
end sub
 
sub PrintPalette ()
  
  const Block = chr(143, 143, 143)

  dim as long i, x, col
  dim as string c
  
  for i = 1 to 16  
    x = 3 * i
    c = mid(Code, i, 1) 
    pen CL_BRIGHT_WHITE : crlocate x, 2 : aprint c
    col = get_ink(asc(c))
    pen col : crlocate x - 1, 4 : aprint Block
  next i

  pen CL_BRIGHT_WHITE : move 0, 270 : ldrawr 800, 0
end sub

sub PrintLegend ()

  const dark  = chr(15, asc("F"))
  const light = chr(15, asc("G"))
  
  crlocate 14, 7 : aprint dark + "Enter the " + light + "Code" + dark + " of the color,"
  crlocate 14, 8 : aprint dark + "or " + light + "Space" + dark + " for transparency."
  crlocate 14,10 : aprint dark + "The " + light + "Arrows" + dark + " move the cursor (*)" 
  crlocate 14,12 : aprint light + "+/-" + dark + " to change the character."
  crlocate 14,14 : aprint light + "!" + dark + " to save the character."
  crlocate 14,16 : aprint light + "Escape" + dark + " to quit the program."

  pen CL_BRIGHT_WHITE 
  move 0, 50 : ldrawr 800, 0
  move 192, 268 : ldrawr 0, -217
  rectangle 15, 206, 129, 129
  crlocate 2, 7 : aprint "Char. "
end sub

sub PrintChar (nchar as long)
  pen CL_BRIGHT_WHITE : crlocate 9, 7 : aprint str(nchar)
end sub

sub PrintStr (nchar as long)
' Writes a 8-sprite string vertically
  
  dim as long y
  for y = 10 to 17
    crlocate 11, y
    aprint chr(nchar)
  next y
end sub

function CursColor (c as string) as string
  if instr("YHWE", c) > 0 then return "A" else return "W"
end function

sub PrintGrid (sprite as string)
  
  dim as string c
  dim as long x, y, n
  
  n = 1

  for y = 10 to 17
    for x = 2 to 9
      crlocate x, y
      c = mid(sprite, n, 1)
      paper get_ink(asc(c))
      if x = x1 and y = y1 then 
        pen get_ink(asc(CursColor(c)))
        aprint "*" 
      else 
        aprint " "
      end if
      n = n + 1
    next x
  next y

  paper CL_BLUE
  pen CL_BRIGHT_WHITE
end sub


