' Characters of the Amstrad font

#include "amsgraph.bi"

declare sub PrintCode ()

dim shared as long n, n1, x, x1, y, y1
dim as string a

mode 1, "Amstrad Font"

aprint chr(1)  ' Print control characters

paper &h000060 : gcls

pen CL_GREEN
for y = 1 to 8
  for x = 5 to 36
    crlocate x, 2 * y
    aprint chr(n)
    n = n + 1
  next x
next y

crlocate 3, 21
pen CL_BRIGHT_CYAN
aprint chr(240, 241, 242, 243) & " moves selection -- ESCAPE quits"

x = 5 : x1 = x
y = 2 : y1 = y
n = 0 : n1 = n

PrintCode

do
  a = ainkey()
  select case a
    case "RIGHT"
      if x < 36 then x1 = x + 1 : n1 = n + 1
    case "LEFT"
      if x > 5  then x1 = x - 1 : n1 = n - 1
    case "DOWN"
      if y < 16 then y1 = y + 2 : n1 = n + 32
    case "UP"
      if y > 2  then y1 = y - 2 : n1 = n - 32
  end select
   PrintCode
loop until a = "ESCAPE" 

end

sub PrintCode
  if n1 <> n then pen CL_GREEN : crlocate x, y : aprint chr(n)
  pen CL_BRIGHT_GREEN
  crlocate x1, y1
  aprint chr(n1)
  crlocate 10, 24
  aprint "Character " & chr(n1) & "   Code " & n1 & "  "
  x = x1 : y = y1 : n = n1
end sub
